local base = _G

module('me_ship')

local require   = base.require
local ipairs    = base.ipairs
local next      = base.next

--  LuaGUI
local DialogLoader = base.require('DialogLoader')

--   
local S 		= base.require('Serializer')

--  Black Shark
local U 					= require('me_utilities')	--    
local UC				    = require('utils_common')
local MapWindow 			= require('me_map_window')
local crutches 				= require('me_crutches')  -- temporary crutches
local mod_tabs				= require('me_tabs')
local Mission 				= require('me_mission')
local i18n 					= require('i18n')
local GroupVariant			= require('GroupVariant')
local OptionsData			= require('Options.Data')
local CoalitionController	= require('Mission.CoalitionController')
local panel_showId			= require('me_showId')
local me_db_api				= require('me_db_api')
local panel_aircraft	    = require('me_aircraft')
local panel_static			= require('me_static')
local panel_vehicle			= require('me_vehicle')
local ListBoxItem			= require('ListBoxItem')
local pPayload_ships		= require('me_payload_ships')

i18n.setup(_M)

vdata = { }

-------------------------------------------------------------------------------
-- 
function initModule()
    --    ( ,       ,
    --  IMHO     ,     )
    cdata = 
    {
        title 				= _('NAVY GROUP'),
		condition 			= _('CONDITION'),
		probability 		= _('%'),		
        country 			= _('COUNTRY'), 
        name 				= _('NAME'),
        hidden 				= _('HIDDEN ON MAP'),
        lateActivation 		= _('LATE ACTIVATION'),
        visibleBeforeStart 	= _('VISIBLE BEFORE START'),
        unit 				= _('UNIT'), 
        unit_of 			= _('OF'), 
        type 				= _('TYPE'), 
        unitName 			= _('UNIT NAME'),
        skill 				= _('SKILL'),
        skillList 			= crutches.getSkillsNames(false),
        heading 			= _('HEADING'),
        placeUnitOnSea 		= _('You are trying to place new ship on the land.\
Please move ship group to allow new ship to be created on water'),
        unit1 = _('Unit #001'),
		uncontrollable 		= _('UNCONTROLLABLE'),
		frequency 			= _('FREQUENCY'),
		modulation			= _('MODULATION'),
		MHz					= _('MHz'),
    }
    
    if base.LOFAC then
        cdata.unit1     = _("Unit #1-LOFAC")
        cdata.unitName  = _('UNIT NAME-LOFAC')
        cdata.unit      = _("UNIT-LOFAC")
    end

    --  /  (   - cdata.vdata_file)
    vdata.country = 'Russia'
    vdata.countries = {'Russia', 'UK', 'Ukraine', 'USA',}
    vdata.name = _('New Ship Group')
    vdata.unit = {number = 1, cur = 1}
    --      
    vdata.types = {'Neustrashimy 11540 FFG (NEUSTRASHIMY Class Frigate)',}	--       
    vdata.skills = { _('Average'), }
    vdata.names = { cdata.unit1, }
    vdata.lastHeading = 0
	
	SafeMode_ = true
end;

initModule();

function fill_combo(combo, t)
    combo:clear()  
    if not t then
        combo:setText("")
        return
    end 
    for i, type in ipairs(t) do
        local DisplayName = me_db_api.getDisplayNameByName(type)
        local item = ListBoxItem.new(DisplayName)
        item.type = type
        item.DisplayName = DisplayName
        item.index = i
        combo:insertItem(item)
        
    end

end

function setTypeItem(a_type)    
    local counter = c_type:getItemCount() - 1
		
    for i = 0, counter do
        local item = c_type:getItem(i)
        
        if item.type == a_type then
            c_type:selectItem(item)
            break
        end
    end
end

-------------------------------------------------------------------------------
--    
--   : t - text, b - button, c - combo, sp - spin, sl - slider, e - edit, d - dial 
function create(x, y, w, h)
    window = DialogLoader.spawnDialogFromFile('MissionEditor/modules/dialogs/me_ship_group.dlg', cdata)
    window:setBounds(x, y, w, h)
 
    btnShowId = DialogLoader.findWidgetByName(window, "btnShowId")
    btnShowId.onChange = onChange_ShowId
    
    vdata.countries = CoalitionController.getActiveCountries()
    country_ship_list = {}
    for i,v in base.pairs(me_db_api.db.Countries) do
        local w = {}
        
        country_ship_list[v.Name] = w
        
        for j,u in base.pairs(v.Units.Ships.Ship) do
          if not me_db_api.unit_by_type[u.Name] then 
            base.print("check unit ", u.Name) 
          else
            base.table.insert(w, u.Name)
          end
        end
        
        base.table.sort(w)
    end
       

    function window:onClose()
        pPayload_ships.show(false)
        base.panel_paramFM.show(false)
        base.panel_radio.show(false)
        base.panel_route.show(false)
		base.panel_suppliers.show(false)
        base.panel_wpt_properties.show(false)
        base.panel_targeting.show(false)
        base.panel_summary.show(false)
        base.panel_triggered_actions.show(false)
        MapWindow.setState(MapWindow.getPanState())
        show(false)
        base.toolbar.setShipButtonState(false)
        base.panel_units_list.show(false);
        MapWindow.unselectAll();
    end
    
    -- Country
    c_country = window.c_country
    U.fill_combo(c_country, vdata.countries)
    c_country:setText(vdata.country) 
    
    function c_country:onChange()
        --     ,     
        local country = self:getText()
        if #country_ship_list[country] == 0 then
            self:setText(vdata.country)
            return
        end
        vdata.country = self:getText()
        changeCountry(vdata.country)
        if vdata.group then
            local unit =  vdata.group.units[vdata.unit.cur];
            base.module_mission.relinkChildren(unit)
        end
    end
        
    -- Name
    e_name = window.e_name
    e_name:setText(vdata.name)

    function e_name:onChange()
        vdata.name = base.module_mission.check_group_name(self:getText())
        if vdata.group then
            base.module_mission.renameGroup(vdata.group, vdata.name)
            base.panel_units_list.updateRow(vdata.group, vdata.group.units[vdata.unit.cur]);
        end
    end

    sp_unit = window.sp_unit
    sp_unit:setRange(1,vdata.unit.number)
    sp_unit:setValue(vdata.unit.cur)

    function sp_unit:onChange()
        vdata.unit.cur = self:getValue()
        if vdata.group then
            for i=1,vdata.unit.number do
                vdata.group.mapObjects.units[i].currColor = vdata.group.boss.boss.selectGroupColor
            end
            vdata.group.mapObjects.units[vdata.unit.cur].currColor = vdata.group.boss.boss.selectUnitColor
            if vdata.unit.cur == 1 then
                vdata.group.mapObjects.route.points[1].currColor = vdata.group.boss.boss.selectUnitColor
            else
                vdata.group.mapObjects.route.points[1].currColor = vdata.group.boss.boss.selectGroupColor
            end;
            base.module_mission.update_group_map_objects(vdata.group)
            e_unit_name:setText(vdata.group.units[vdata.unit.cur].name)
            pPayload_ships.setUnit(vdata.group.units[vdata.unit.cur]) -- uboats
            base.module_mission.updateHeading(vdata.group, vdata.unit.cur);
            base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
            base.panel_route.update()
        end
        setTypeItem(vdata.types[vdata.unit.cur]) 
        c_skill:setText(vdata.skills[vdata.unit.cur]) 
		update()
		base.panel_suppliers.setGroup(vdata.group, vdata.group.units[vdata.unit.cur])
		base.panel_suppliers.resetFullInfo()
    end
        
    
    local maxUnitCount = 99
    sp_of = window.sp_of
    sp_of:setRange(1, maxUnitCount)
    sp_of:setValue(vdata.unit.number)

    function sp_of:onChange()
        local n = self:getValue()
        if n < vdata.unit.number then
            for i = vdata.unit.number, n+1, -1 do
                base.table.remove(vdata.types, i)
                base.table.remove(vdata.skills, i)
                if vdata.group then
                    --       
                    base.module_mission.remove_unit(vdata.group.units[i])
                end
            end
        elseif n > vdata.unit.number then
            for i=vdata.unit.number+1,n do
                if vdata.group then
                
                    -- TODO:   
                    --   800 
                    local offset = 800
                    local x = vdata.group.x - offset * (i - 1)
                    local y = vdata.group.y + offset * (i - 1)
                    warningCallback = function ()
                        MapWindow.showWarningWindow(cdata.placeUnitOnSea)
                    end; 
                    local res = MapWindow.checkSurface(vdata.group, x, y, true, warningCallback);
                    if res == false then
                        local _n = n-1;
                        if _n >= 1 then
                            self:setValue(_n);
                        end;
                        return;
                    end;                        
                    base.table.insert(vdata.types, vdata.types[vdata.unit.cur])
                    base.table.insert(vdata.skills, vdata.skills[vdata.unit.cur])
                    --       
                    base.module_mission.insert_unit(vdata.group, 
                            vdata.types[vdata.unit.cur], vdata.skills[vdata.unit.cur], i, nil, 
                            x, y, 
                            vdata.group.units[vdata.unit.cur].heading)
                end
            end
        end
        vdata.unit.number = n
        vdata.unit.cur = vdata.unit.number
        setTypeItem(vdata.types[vdata.unit.cur])
        if vdata.group then
            for i=1,vdata.unit.number do
                vdata.group.mapObjects.units[i].currColor = vdata.group.boss.boss.selectGroupColor
            end
            vdata.group.mapObjects.route.points[1].currColor = vdata.group.boss.boss.selectGroupColor
            vdata.group.mapObjects.units[vdata.unit.cur].currColor = vdata.group.boss.boss.selectUnitColor
            base.module_mission.update_group_map_objects(vdata.group)
                        e_unit_name:setText(vdata.group.units[vdata.unit.cur].name)
        end
        sp_unit:setRange(1, vdata.unit.number)
        sp_unit:setValue(vdata.unit.cur)
        
        c_skill:setText(vdata.skills[vdata.unit.cur]) 
        base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
        base.panel_route.update()
        base.panel_units_list.updateRow(vdata.group, vdata.group.units[vdata.unit.cur]);
		update()
		base.panel_suppliers.setGroup(vdata.group, vdata.group.units[vdata.unit.cur])
		base.panel_suppliers.resetFullInfo()
    end
        
    c_type = window.c_type
    fill_combo(c_type, country_ship_list[vdata.country])
    setTypeItem(vdata.types[vdata.unit.cur]) 
    
    function c_type:onChange()
		if vdata.group then
			local ship = me_db_api.ship_by_type[vdata.types[vdata.unit.cur]]	
			local shipNew = me_db_api.ship_by_type[self:getSelectedItem().type]
		
			if (me_db_api.isCarrier(ship)) and (me_db_api.isCarrier(shipNew) == false) then
				--  
				base.module_mission.delWarehouse(vdata.group.units[vdata.unit.cur].unitId)  			
				--l_suppliers:clear()    
				MapWindow.setState(MapWindow.getPanState())
				base.panel_targeting.b_add:setState(false)
			end
		end
		
        vdata.types[vdata.unit.cur] = self:getSelectedItem().type
		
        if vdata.group then
            base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]			
            base.panel_route.update()
            --            .
            local unit =  vdata.group.units[vdata.unit.cur];
            unit.type = vdata.types[vdata.unit.cur]
            MapWindow.updateSelectedGroup(vdata.group)
            base.module_mission.relinkChildren(unit)
            pPayload_ships.setUnit(unit) -- uboats
            pPayload_ships.setDefaultLivery(unit) -- uboats
        end
		--_tabs:selectTab('route')	
		update()
    end
        
    -- Unit name
    e_unit_name = window.e_unit_name
    function e_unit_name:onChange()
        local name = self:getText()
        local group = vdata.group
        if group then
            local unit = group.units[vdata.unit.cur]
            base.module_mission.renameUnit(unit, name)
        else
            vdata.names[1] = name
        end
    end
        
    -- Skill
    c_skill = window.c_skill
    U.fill_combo(c_skill, cdata.skillList)
    c_skill:setText(vdata.skills[vdata.unit.cur]) 
    
    function c_skill:onChange()
        vdata.skills[vdata.unit.cur] = self:getText()
        if vdata.group then
            vdata.group.units[vdata.unit.cur].skill = self:getText()
        end
    end

    -- Heading --------------------------------------------------------------
    t_heading = window.t_heading
    
    sp_heading = window.sp_heading
    sp_heading:setRange(0, 359)
    sp_heading:setValue(0)
    
    function sp_heading:onChange()
      local n = self:getValue()
      
  --    vdata.group.units[vdata.unit.cur].heading = U.toRadians(n)
	  setHeadingUnit(vdata.group.units[vdata.unit.cur], U.toRadians(n))
      vdata.lastHeading = U.toRadians(n)
      d_heading:setValue(n)
      updateHeading(vdata.group)
    end
    
    d_heading = window.d_heading

    function d_heading:onChange()
      --vdata.group.units[vdata.unit.cur].heading = U.toRadians(self:getValue())
	  setHeadingUnit(vdata.group.units[vdata.unit.cur], U.toRadians(self:getValue()))
      vdata.lastHeading = U.toRadians(self:getValue())
      sp_heading:setValue(base.math.floor(self:getValue()))
      updateHeading(vdata.group)
    end
        
    hiddenCheckbox = window.hiddenCheckbox
    hiddenCheckbox.onChange = MapWindow.OnHiddenCheckboxChange;
	
    lateActivationCheckbox = window.lateActivationCheckbox
    function lateActivationCheckbox:onChange()
      if vdata.group then
        vdata.group.lateActivation = self:getState()
        vdata.group.route.routeRelativeTOT = self:getState()
        base.panel_route.onLateActivationChanged()
        base.panel_summary.updateStartTime()
		e_group_condition:setEnabled(not vdata.group.lateActivation)
        sp_probability:setEnabled(not vdata.group.lateActivation)
      end
    end	

    visibleCheckbox = window.visibleCheckbox
    function visibleCheckbox:onChange()
        if vdata.group then
            vdata.group.visible = self:getState();
        else
            self:setState(false)
        end;
    end;

	e_group_condition = window.e_group_condition	
	function e_group_condition:onChange()
      if vdata.group then
        vdata.group.condition = self:getText()
      end
	end
	
    sp_probability = window.sp_probability
    function sp_probability:onChange()
      if vdata.group then
        vdata.group.probability = self:getValue() / 100
      end
    end
	
    probabilityLabel = window.probabilityLabel
	
	cbUncontrollable = window.cbUncontrollable
	
	function cbUncontrollable:onChange()
		if vdata.group then
			vdata.group.uncontrollable = self:getState()
		end
	end
	
	groupVariant = GroupVariant.new(window)
        
    local cx, cy, cw, ch = window:getClientRect()
    
    _tabs = mod_tabs.createUnitTabs('ship', window, 0, ch - U.widget_h -9)
	
	sp_frequency = window.sp_frequency
	sp_frequency.onChange = function(self)
		if vdata.group then
			vdata.group.units[vdata.unit.cur].frequency = 1000000 * self:getValue()
		end
	end
	
	c_modulation = window.c_modulation
	
	local modulationTypeTable = {
		{name = _('AM'),	value = 0},
		{name = _('FM'),	value = 1}
	}

	U.fillComboList(c_modulation, modulationTypeTable)
	
	c_modulation.onChange = function(self, item)
		if vdata.group then
			vdata.group.units[vdata.unit.cur].modulation = item.itemId.value
		end
	end
end

function onChange_ShowId()
    panel_showId.setGroup(vdata.group)
    panel_showId.show(true)
end

-------------------------------------------------------------------------------
function setPlannerMission(planner_mission)
	if (planner_mission == true) then
		c_country:setEnabled(false)
		e_name:setEnabled(false)
		sp_of:setEnabled(false)
		c_type:setEnabled(false)
		e_unit_name:setEnabled(false)
		c_skill:setEnabled(false)
		sp_heading:setEnabled(false)
		d_heading:setEnabled(false)
		hiddenCheckbox:setVisible(false)
		lateActivationCheckbox:setVisible(false)
		visibleCheckbox:setVisible(false)
		e_group_condition:setVisible(false)
		sp_probability:setVisible(false)
		cbUncontrollable:setEnabled(false)
	else
		c_country:setEnabled(true)
		e_name:setEnabled(true)
		c_type:setEnabled(true)
		e_unit_name:setEnabled(true)
		c_skill:setEnabled(true)		
		hiddenCheckbox:setVisible(true)
		lateActivationCheckbox:setVisible(true)
		visibleCheckbox:setVisible(true)
		if (SafeMode_ == false) then
			sp_heading:setEnabled(true)
			d_heading:setEnabled(true)
		else
			sp_heading:setEnabled(false)
			d_heading:setEnabled(false)
		end
		e_group_condition:setVisible(true)
		sp_probability:setVisible(true)
		cbUncontrollable:setEnabled(true)
	end
	
end

-------------------------------------------------------------------------------
function setGroup(group)
	vdata.group = group
	groupVariant:initialize(vdata.group and vdata.group.variantProbability, 1)	
end

-------------------------------------------------------------------------------
-- / 
function show(b)
	setPlannerMission(base.isPlannerMission())
    if b == window:isVisible() then
        return
    end
	window:setVisible(b)
	if b then
		groupVariant:initialize(vdata.group and vdata.group.variantProbability, 1)
        update()        
	else
		vdata.group = nil
	end  
end

-------------------------------------------------------------------------------
--    
function load(fName)
    base.dofile(fName)
    vdata = base.vdata
end

-------------------------------------------------------------------------------
--    
function save(fName)
    local f = base.io.open(fName, 'w')
    if f then
        local s = S.new(f)
        s:serialize_simple('vdata', vdata)
        f:close()
    end
end

--   
function setCountry(c)
    vdata.country = c
    updateCountry()    
end

function updateCountry()   
    for i=1,#vdata.types do
        vdata.types[i] = country_ship_list[vdata.country][1]
    end
    fill_combo(c_type, country_ship_list[vdata.country]) 
    setTypeItem(vdata.types[vdata.unit.cur]) 
end    

-------------------------------------------------------------------------------
-- 
function changeCountry(c)
    panel_aircraft.setCountry(c)
    panel_static.setCountry(c)
    panel_vehicle.setCountry(c)
    
    vdata.country = c
    updateCountry()
    if vdata.group then
        --     . 
        local tbl = vdata.group.boss.ship.group
        if tbl then
            for i,v in base.pairs(tbl) do
                if v == vdata.group then
                    base.table.remove(tbl, i)
                    break
                end
            end
        end
        base.module_mission.remove_group_map_objects(vdata.group)
        --     .
        local c = base.module_mission.missionCountry[vdata.country]
        base.table.insert(c.ship.group, vdata.group)
        vdata.group.boss = c
        --    
        vdata.group.color = c.boss.color
        fill_combo(c_type, country_ship_list[vdata.country])
        --              .
        --   ,      .
        vdata.types = {}
        for i=1,#vdata.group.units do
            local unit = vdata.group.units[i]
            unit.type = country_ship_list[vdata.country][1]
            base.table.insert(vdata.types, unit.type)
            pPayload_ships.setDefaultLivery(unit) -- uboats
        end
        setTypeItem(country_ship_list[vdata.country][1])
        base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
        base.panel_route.update()
        pPayload_ships.setUnit(vdata.group.units[vdata.unit.cur]) -- uboats
        base.panel_targeting.update()
        MapWindow.updateSelectedGroup(vdata.group)
        base.panel_units_list.updateRow(vdata.group, vdata.group.units[vdata.unit.cur]);
    end
	update()
end

-------------------------------------------------------------------------------
-- disable editing of unsafe elements
function setSafeMode(enable)
	SafeMode_ = enable
    local e = not enable

    sp_unit:setEnabled(e)
    sp_of:setEnabled(e)
    _tabs:setEnabled(e)
    sp_heading:setEnabled(e)
    d_heading:setEnabled(e)
end


-------------------------------------------------------------------------------
--			 									         ---------------------------
-------------------------------------------------------------------------------


-------------------------------------------------------------------------------
--			 									         ---------------------------
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- 
function update()
    --changeCountry(vdata.country)
    c_country:setText(vdata.country)
    e_name:setText(vdata.name) 
    sp_unit:setValue(vdata.unit.cur)
    sp_unit:setRange(1,vdata.unit.number) 
    sp_of:setValue(vdata.unit.number)	
    fill_combo(c_type, country_ship_list[vdata.country]) 
    setTypeItem(vdata.types[vdata.unit.cur]) 
    if vdata.group then
        if vdata.group.units[vdata.unit.cur].name then 
            e_unit_name:setText(vdata.group.units[vdata.unit.cur].name)
        else
            e_unit_name:setText('')
        end
        vdata.types = {};
        for i = 1, #vdata.group.units do
            base.table.insert(vdata.types, vdata.group.units[i].type);
        end;    
		cbUncontrollable:setState(vdata.group.uncontrollable or false)	
        hiddenCheckbox:setState(vdata.group.hidden)
		lateActivationCheckbox:setState(vdata.group.lateActivation)
		visibleCheckbox:setState(vdata.group.visible)
		e_group_condition:setEnabled(not vdata.group.lateActivation)
		e_group_condition:setText(vdata.group.condition)
		sp_probability:setEnabled(not vdata.group.lateActivation)
		sp_probability:setValue((vdata.group.probability or 1.0) * 100)
		if vdata.group.units[vdata.unit.cur].frequency == nil then
			local unitDef = me_db_api.unit_by_type[vdata.group.units[vdata.unit.cur].type]  
			vdata.group.units[vdata.unit.cur].frequency = unitDef.frequency or 127500000
		end
		sp_frequency:setValue((vdata.group.units[vdata.unit.cur].frequency or 127500000)/1000000)
		if vdata.group.units[vdata.unit.cur].modulation == nil then
			vdata.group.units[vdata.unit.cur].modulation = 0
		end
		U.setComboBoxValue(c_modulation, vdata.group.units[vdata.unit.cur].modulation or 0)
        base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
		base.panel_route.updateAltSpeed()
        base.panel_route.update()
        pPayload_ships.setUnit(vdata.group.units[vdata.unit.cur]) -- uboats
		updateHeading(vdata.group)
    end
	
	local ship = me_db_api.ship_by_type[vdata.types[vdata.unit.cur]]
	if ship and (me_db_api.isCarrier(ship)) then
		_tabs:showTab('suppliers')
	else
		_tabs:hideTab('suppliers')
	end

    c_skill:setText(vdata.skills[vdata.unit.cur])
end

-------------------------------------------------------------------------------
-- 
function updateCountries()
	local c = CoalitionController.getActiveCountries()
    --         
    vdata.countries = {}
    for i=1,#c do
        if #country_ship_list[c[i] ] > 0 then
            base.table.insert(vdata.countries, c[i])
        end
    end
    if #vdata.countries > 0 then
        U.fill_combo(c_country, vdata.countries)
        vdata.country = c_country:getText()
        changeCountry(vdata.country)
    else
        vdata.country = nil
    end
end

-------------------------------------------------------------------------------
--
function updateHeading(a_group)
    local heading = 0;
	
	sp_heading:setVisible(true);
	d_heading:setVisible(true);
	t_heading:setVisible(true);
	
    if a_group then
		if (#a_group.route.points > 1) then
			sp_heading:setVisible(false);
			d_heading:setVisible(false);
			t_heading:setVisible(false);
			local p1 = a_group.route.points[1];
			local p2 = a_group.route.points[2];

			if (p1.x == p2.x) and (p1.y == p2.y) then
				base.print('Waypoints equal!', p1.index, p2.index);
				heading = 0
			else
				heading = MapWindow.getAngle(p1, p2) 	
				if (heading < 0) then
					heading = heading + 2 * base.math.pi
				end
			end;
			
			for k, unit in base.pairs(a_group.units) do				
				setHeadingUnit(unit, heading)					
			end
		end

        sp_heading:setValue(UC.toDegrees(a_group.units[vdata.unit.cur].heading));
        d_heading:setValue(UC.toDegrees(a_group.units[vdata.unit.cur].heading));
    end;
	
	if a_group then
		for k,unitObj in base.pairs(a_group.mapObjects.units) do
			local unitMapObject = a_group.mapObjects.units[k]
			local classInfo = MapWindow.getClassifierObject(unitMapObject.classKey)
	
			if classInfo and classInfo.rotatable and OptionsData.getIconsTheme() == 'russian' then	
				unitObj.angle = MapWindow.headingToAngle(a_group.units[k].heading) --       
	  
				if k == 1 then
					a_group.mapObjects.route.points[1].angle = MapWindow.headingToAngle(a_group.units[1].heading)
				end
			end	
			if unitObj.picIcon then
				unitObj.picIcon.angle = MapWindow.headingToAngle(a_group.units[k].heading)
			end
			
			if unitObj.picModel then
				unitObj.picModel:setOrientationEuler(MapWindow.headingToAngle(a_group.units[k].heading), 0, 0)
			end
			
			base.module_mission.update_group_map_objects(a_group) 
		end
	end
end

function setHeadingUnit(a_unit, a_heading)
	local dHeading = a_heading - a_unit.heading	
	a_unit.heading = a_heading

	if a_unit.linkChildren then
		for i,linkWpt in ipairs(a_unit.linkChildren) do		
			if linkWpt.boss.linkOffset == true then				
				local dx =  linkWpt.x - a_unit.x
				local dy =  linkWpt.y - a_unit.y 
				local sinHdg = base.math.sin(dHeading)
				local cosHdg = base.math.cos(dHeading)
				local offsetX, offsetY = 0, 0	
				
				offsetX = dx*cosHdg - dy*sinHdg
				offsetY = dy*cosHdg + dx*sinHdg	

				if MapWindow.checkSurface(linkWpt.boss, a_unit.x+offsetX, a_unit.y+offsetY, nil, nil, 1) then 
					MapWindow.move_group(linkWpt.boss, a_unit.x+offsetX, a_unit.y+offsetY)
					MapWindow.move_waypoint(linkWpt.boss, 1, a_unit.x+offsetX, a_unit.y+offsetY, nil, true)
				end
				
				linkWpt.boss.units[1].heading = (linkWpt.boss.units[1].heading or 0) + dHeading
				panel_static.updateHeadingUnit(linkWpt.boss.units[1])
			end
		end
	end
	

end


